# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider

AVIA_NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'kz': 'KZT',
    'tr': 'TRY',
    'com': 'EUR',
}
NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'kz': 'KZT',
    'tr': 'TRY',
    'com': 'EUR',
}
NATIONAL_CURRENCY_RATES_GEOID = {
    'com': 10376,
    'kz': 163,
    'ru': 213,
    'tr': 11508,
    'ua': 143,
}
CURRENCY_RATES_TIMEOUT = 0.1
CURRENCY_RATES_URL = env_variable_provider.get(
    'CURRENCY_RATES_URL'
)

AVIA_NATIONAL_VERSION_ALLOWED_FOREIGN_CURRENCIES = {
    'ru': frozenset(('USD', 'EUR', 'GBP', 'CAD')),
    'ua': frozenset(('BYR', 'BYN', 'CHF', 'EUR', 'GBP', 'JPY', 'KZT', 'NOK', 'RUB', 'RUR', 'TRY', 'UAH', 'USD')),
    'kz': frozenset(('EUR', 'USD', 'RUB', 'RUR', 'CAD')),
    'tr': frozenset(('JPY', 'USD', 'CHF', 'CNY', 'TRY', 'UAH', 'GBP', 'RUB', 'RUR', 'EUR')),
    'com': frozenset((
        'AUD', 'BGN', 'BRL', 'CAD', 'CHF', 'CNY', 'CZK', 'DKK', 'GBP', 'HKD', 'HRK', 'HUF', 'IDR',
        'ILS', 'INR', 'JPY', 'KRW', 'MXN', 'MYR', 'NOK', 'NZD', 'PHP', 'PLN', 'RON', 'RUB', 'RUR',
        'SEK', 'SGD', 'THB', 'TRY', 'USD', 'ZAR',
    )),
}
