# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import
import os

from copy import deepcopy

from travel.avia.library.python.common.mdb.mysql import get_replica_info
from travel.avia.library.python.common.utils import dcutils

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider
from travel.avia.ticket_daemon.ticket_daemon.settings.caches import CACHE_PATH
from travel.avia.ticket_daemon.ticket_daemon.settings.environment import (
    YANDEX_ENVIRONMENT_TYPE, CURRENT_DC,
)
from travel.avia.ticket_daemon.ticket_daemon.settings.logs import LOG_PATH


conductor = dcutils.Conductor(
    log_file_path=os.path.join(LOG_PATH, 'dcutils.log'),
    cache_path=CACHE_PATH
)

MYSQL_CLUSTER_ID = env_variable_provider.get('MYSQL_CLUSTER_ID', required=False)
MYSQL_CONN_MAX_AGE = int(env_variable_provider.get('MYSQL_CONN_MAX_AGE', required=False, default=0))

MYSQL_CONNECT_TIMEOUT = 1
MYSQL_READ_TIMEOUT = 60
MYSQL_WRITE_TIMEOUT = 3

DATABASES = {
    'default': {
        'ATOMIC_REQUESTS': False,
        'AUTOCOMMIT': True,
        'CONN_MAX_AGE': MYSQL_CONN_MAX_AGE,
        'ENGINE': 'travel.avia.ticket_daemon.ticket_daemon.daemon.mysql_switcher',
        'HOST': None,
        'NAME': env_variable_provider.get('MYSQL_DATABASE_NAME'),
        'OPTIONS': {},
        'PASSWORD': env_variable_provider.get('MYSQL_PASSWORD', required=False),
        'PORT': env_variable_provider.get('MYSQL_PORT', required=False) or '',
        'STORAGE_ENGINE': 'InnoDB',
        'TEST': {
            'CHARSET': None,
            'COLLATION': None,
            'MIRROR': None,
            'NAME': None
        },
        'TIME_ZONE': 'Europe/Moscow',
        'USER': env_variable_provider.get('MYSQL_USER')
    }
}
DATABASES['writable'] = deepcopy(DATABASES['default'])

if YANDEX_ENVIRONMENT_TYPE != 'development':
    if MYSQL_CLUSTER_ID:
        replica_info = get_replica_info({
            'MYSQL_CLUSTER_ID': MYSQL_CLUSTER_ID,
            'MDB_API_TOKEN': env_variable_provider.get('MDB_API_TOKEN')
        }, CURRENT_DC)
    else:
        slave_group = {
            'production': 'avia_db_mysql_main',
            'testing': 'avia_test_db_mysql_main',
            'load': 'avia_load_db_mysql_main'
        }[YANDEX_ENVIRONMENT_TYPE]
        master_group = slave_group + '_master'
        replica_info = conductor.get_groups_mysql_replicainfo(
            slave_group, master_group
        )

    DATABASES['default']['REPLICAS'] = replica_info.replicas
    DATABASES['writable']['REPLICAS'] = replica_info.replicas
    DATABASES['writable']['HOST'] = replica_info.master
else:
    DATABASES['default']['HOST'] = env_variable_provider.get('MYSQL_HOST', required=False) or 'localhost'

TEST_DB_NAME = env_variable_provider.get(
    'MYSQL_TEST_DATABASE_NAME',
    required=False
)
