# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

import os

from library.python.django.utils import patch_settings_for_arcadia
from travel.avia.ticket_daemon.ticket_daemon.settings.environment import DEBUG, DISCOVERY_INSTANCE_NAME
from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider

TEMPLATE_DEBUG = DEBUG
DEFAULT_FILE_STORAGE = "travel.avia.library.python.common.utils.fields.TransliteratingFileSystemStorage"
DEFAULT_FROM_EMAIL = 'rasp-tech@yandex-team.ru'
LANGUAGE_CODE = 'ru'
LANGUAGE_COOKIE_NAME = 'lang'
SITE_ID = 1
MEDIA_ROOT = ''
MEDIA_URL = '//yastatic.net/rasp/media/'
STATICFILES_DIRS = ()
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder'
]
ADMINS = ()
MANAGERS = ADMINS
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
)
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'APP_DIRS': True,
        'DIRS': ['travel/avia/ticket_daemon/ticket_daemon/templates'],
    },
]

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware'
)
SECRET_KEY = env_variable_provider.get(
    'SECRET_KEY'
)
TIME_ZONE = 'Europe/Moscow'
USE_TZ = True
USE_I18N = True
USE_L10N = True
SERVER_EMAIL = 'Rasp at %s <rasp-tech@yandex-team.ru>' % DISCOVERY_INSTANCE_NAME
LOCALE_PATHS = [
    os.path.normpath(os.path.join(
        os.path.dirname(__file__),
        '..', 'virtualenv', 'django', 'conf', 'locale'
    ))
]
EMAIL_SUBJECT_PREFIX ='[Django-avia@{}] '.format(DISCOVERY_INSTANCE_NAME)
STATIC_URL = '/static/'
INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'travel.avia.library.python.common',
    'travel.avia.library.python.avia_data',
    'travel.avia.ticket_daemon.ticket_daemon',
    'travel.avia.library.python.common.app_stubs.www',
    'travel.avia.library.python.common.app_stubs.currency',
    'travel.avia.library.python.common.app_stubs.order',
)

patch_settings_for_arcadia()
