# -*- coding: utf-8 -*-
from __future__ import absolute_import
import os

from travel.avia.library.python.environment_helpers.env_variable_provider import EnvironmentVariableProvider

SERVICE_NAME = 'AVIA_TICKET_DAEMON'
env_variable_provider = EnvironmentVariableProvider(SERVICE_NAME)

DEBUG = env_variable_provider.get(
    'DEBUG', required=False
) == 'true'
YANDEX_ENVIRONMENT_TYPE = env_variable_provider.get(
    'environment_type'
)
ENVIRONMENT = {
    'production': 'production',
    'testing': 'testing',
    'development': 'dev'
}[YANDEX_ENVIRONMENT_TYPE]
CURRENT_DC = os.getenv('DEPLOY_NODE_DC')

PKG_VERSION = os.getenv('DEPLOY_DOCKER_IMAGE') or 'dev-{}'.format(os.getenv('USER'))
PROJECT_PATH = os.path.normpath(os.path.join(os.path.abspath(os.path.dirname(__file__)), '../..'))

DISCOVERY_INSTANCE_NAME = os.getenv('DEPLOY_POD_PERSISTENT_FQDN')
