# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from django.utils.translation import ugettext_lazy as _

MODEL_LANGUAGES = ['ru', 'en', 'tr', 'uk']
LANGUAGE_CASE_FALLBACKS = {('uk', 'genitive'): [('ru', 'genitive')]}
LANGUAGE_FALLBACKS = {'de': ['en'], 'tr': ['en'], 'uk': ['ru']}

AVIA_NATIONAL_VERSIONS = ['ru', 'ua', 'tr', 'com', 'kz']
AVIA_NATIONAL_VERSIONS_CHOICES = tuple([
    (v, v) for v in AVIA_NATIONAL_VERSIONS]
)
AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN = 5
LANGUAGES = [
    ('ru', _(u'Русский')),
    ('be', _(u'Белорусский')),
    ('kk', _(u'Казахский')),
    ('tt', _(u'Татарский')),
    ('uk', _(u'Украинский')),
    ('en', _(u'Английский')),
    ('tr', _(u'Турецкий'))
]
