# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

import logging
import os

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider
from travel.avia.ticket_daemon.ticket_daemon.settings.environment import YANDEX_ENVIRONMENT_TYPE

YT_LOGGERS = (
    'yt.timeline', 'yt.partners_query', 'yt.avia_partner_cache', 'yt.min_price', 'yt.baggage_info', 'yt.json_filter',
    'yt.avia_variants', 'rasp.order.dump_seat_price', 'yt.unknown_companies', 'yt.unknown_station_codes',
    'yt.avia-init-search', 'yt.wizard-search-result', 'yt.avia-search-result', 'yt.processed-qids',
)


def create_logging_setting(log_path, yandex_environment_type):
    logging_dict = {
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'level': 'INFO',
            'handlers': ['main_tree', 'error', 'traceback'],
        },
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s: %(message)s'
            },
            'message_only': {
                'format': '%(message)s'
            },
            'error': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
                'full': True,
                'show_locals': True
            },
        },
        'handlers': {
            'sentry': {
                'level': 'ERROR',
                'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
                'tags': {
                    'environment': YANDEX_ENVIRONMENT_TYPE,
                    'DEPLOY_NODE_DC': os.getenv('DEPLOY_NODE_DC'),
                    'DEPLOY_STAGE_ID': os.getenv('DEPLOY_STAGE_ID'),
                },
            },
            'error': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'main', 'error.log'),
                'formatter': 'error',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'main', 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            },
            'main_tree': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'verbose',
                'remove_prefix': 'travel.avia.ticket_daemon',
            },
            'main_tree_debug': {
                'level': 'DEBUG',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'verbose',
                'remove_prefix': 'travel.avia.ticket_daemon',
            },
            'tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': log_path,
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon',
            },
            'main_tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon',
            },
            'root_tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': log_path,
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon',
            }
        },
        'loggers': {
            'celery': {
                'handlers': ['main_tree'],
                'level': 'INFO',
            },
            'all_empty_variants_query': {
                'handlers': ['main_tree_handler_message_only'],
                'level': 'INFO',
                'propagate': False,
            },
            'empty_variants_query': {
                'handlers': ['main_tree_handler_message_only'],
                'level': 'INFO',
                'propagate': False,
            },
            'partners_errors': {
                'handlers': ['main_tree'],
                'level': 'ERROR',
                'propagate': False,
            },
            'broken_flight_numbers': {
                'handlers': ['main_tree'],
                'level': 'INFO',
                'propagate': False,
            },
            'dcutils': {
                'handlers': ['main_tree_handler_message_only'],
                'level': 'INFO',
                'propagate': False,
            },
            'timeline': {
                'handlers': ['main_tree_handler_message_only'],
                'level': 'INFO',
                'propagate': False,
            },
        }
    }

    for yt_logger in YT_LOGGERS:
        logging_dict['loggers'][yt_logger] = {
            'handlers': ['root_tree_handler_message_only'],
            'level': 'INFO',
            'propagate': False,
        }

    if yandex_environment_type in ['development', 'testing']:
        logging_dict['loggers']['travel.avia.ticket_daemon.ticket_daemon.partners.dohop'] = {
            'handlers': ['main_tree_debug'],
            'level': 'DEBUG',
        }

    if yandex_environment_type in ['development']:
        logging_dict['root'] = {
            'handlers': ['main_tree_debug', 'error', 'traceback'],
            'level': 'DEBUG',
        }
        logging_dict['loggers']['celery'] = {
            'handlers': ['main_tree_debug'],
            'level': 'DEBUG',
        }

    if yandex_environment_type in ['testing', 'production', 'development']:
        logging_dict['root']['handlers'].append('sentry')
        logging_dict['loggers']['celery']['handlers'].append('sentry')
        logging_dict['loggers']['partners_errors']['handlers'].append('sentry')

    return logging_dict


LOG_PATH = env_variable_provider.get(
    'LOG_PATH'
)
LOGGING = create_logging_setting(LOG_PATH, YANDEX_ENVIRONMENT_TYPE)
LOG_LEVEL = logging.INFO
