# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
from enum import Enum

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider
from travel.avia.library.python.price_prediction import PricePredictionServerEnvironment
from travel.avia.library.python.price_prediction.client import PricePredictionClient, RediscoveringPricePredictionClient

PRICE_PREDICTION_TIMEOUT = float(env_variable_provider.get('PRICE_PREDICTION_TIMEOUT', required=False, default=0.1))


class _AviaEnvironment(Enum):
    PRODUCTION = 'production'
    PREPRODUCTION = 'pre-production'
    TESTING = 'testing'
    UNSTABLE = 'unstable'


_SERVER_ENV_BY_AVIA_ENV = {
    _AviaEnvironment.PRODUCTION: PricePredictionServerEnvironment.PRODUCTION,
    _AviaEnvironment.PREPRODUCTION: PricePredictionServerEnvironment.PRODUCTION,
    _AviaEnvironment.TESTING: PricePredictionServerEnvironment.TESTING,
    _AviaEnvironment.UNSTABLE: PricePredictionServerEnvironment.UNSTABLE,
}


def build_price_prediction_client():
    host = env_variable_provider.get('PRICE_PREDICTION_HOST', required=False)
    if host:
        port = env_variable_provider.get('PRICE_PREDICTION_PORT', required=False, default=9001)
        return PricePredictionClient(host, port)

    raw_avia_environment = os.getenv('DEPLOY_STAGE_ID', '-').split('-')[-1]
    server_environment = _get_server_environment(raw_avia_environment)
    return RediscoveringPricePredictionClient(server_environment)


def _get_server_environment(raw_avia_environment):
    if raw_avia_environment.startswith('pr-'):
        # Для стендов на pull request
        return _SERVER_ENV_BY_AVIA_ENV[_AviaEnvironment.UNSTABLE]

    return _SERVER_ENV_BY_AVIA_ENV[_AviaEnvironment(raw_avia_environment)]
