# -*- coding: utf-8 -*-
from __future__ import absolute_import

import ydb

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider
from travel.avia.ticket_daemon.ticket_daemon.settings import environment

YDB_DATABASE = env_variable_provider.get('YDB_DATABASE')
YDB_ENDPOINT = env_variable_provider.get('YDB_ENDPOINT')

WIZARD_YDB_DATABASE = env_variable_provider.get('WIZARD_YDB_DATABASE')
WIZARD_YDB_ENDPOINT = env_variable_provider.get('WIZARD_YDB_ENDPOINT')


def auth_credentials():
    YDB_TOKEN = env_variable_provider.get('YDB_TOKEN', required=False)
    return ydb.AuthTokenCredentials(YDB_TOKEN)


def tvm_credentials():
    from travel.avia.ticket_daemon.ticket_daemon.lib.tvm_provider import tvm_provider

    class AviaTvmCredentials(ydb.credentials.Credentials):

        def __init__(self, tvm_provider):
            self._tvm_provider = tvm_provider

        def auth_metadata(self):
            return [
                (ydb.credentials.YDB_AUTH_TICKET_HEADER, self._tvm_provider.get_ticket('ydb'))
            ]

    return AviaTvmCredentials(tvm_provider)


def driver_config(endpoint, database):
    if environment.YANDEX_ENVIRONMENT_TYPE in {'testing', 'production'}:
        credentials = tvm_credentials()
    else:
        credentials = auth_credentials()

    return ydb.DriverConfig(
        endpoint,
        database=database,
        credentials=credentials,
    )


DRIVER_CONFIG = driver_config(YDB_ENDPOINT, YDB_DATABASE)
WIZARD_DRIVER_CONFIG = driver_config(WIZARD_YDB_ENDPOINT, WIZARD_YDB_DATABASE)

SESSION_POOL_SIZE = 20
REMOVE_PARTNERS_WITH_EMPTY_RESPONSES_TIMEOUT = 5


def RECREATE_YDB_SESSION_POOL():
    from travel.avia.ticket_daemon.ticket_daemon.lib.feature_flags import recreate_ydb_session_pool
    return recreate_ydb_session_pool()


def WRITE_IN_PARTNER_CACHE():
    return env_variable_provider.get('TD_WIZARD_WRITE_IN_PARTNER_CACHE', required=False, default='false') == 'true'
