# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import gevent
from django.conf import settings
from flask import jsonify, request, Blueprint
from logging import getLogger

from travel.avia.library.python.ticket_daemon.date import unixtime
from travel.avia.ticket_daemon.ticket_daemon.lib.http import with_retry
from travel.avia.ticket_daemon.ticket_daemon.lib.tvm_provider import tvm_provider
from travel.avia.ticket_daemon.ticket_daemon.partners import add_marker_to_url, generate_marker

logger = getLogger(__name__)
book_routes = Blueprint('book routes', __name__)


@book_routes.route('/api/1.0/book_redirect/', methods=['POST'])
def book_redirect():
    session = with_retry(backoff_factor=0.2)
    try:
        response = gevent.with_timeout(
            settings.BOOK_REDIRECT_TIMEOUT,
            session.post,
            url=settings.BOOKING_SERVICE_URL,
            json=dict(request.json, created_at=unixtime()),
            headers={
                'X-Ya-Service-Ticket': tvm_provider.get_ticket(
                    'booking-service'
                )
            },
            timeout=settings.BOOKING_SERVICE_TIMEOUT,
        )

    except gevent.Timeout:
        logger.exception(u'Timeout on Request')
        return 'Booking service request timeout', 408

    except Exception as e:
        logger.exception(u'%s on Request', e)
        return 'Booking service request error', 500

    if response.ok:
        if settings.USE_BACKEND_MARKER_GENERATION:
            marker = generate_marker()
            url = response.json().get('redirectUrl')
            url = add_marker_to_url('referrer', marker, url)

            return jsonify({
                'url': url,
                'marker': marker,
            })
        else:
            return jsonify({'url': response.json().get('redirectUrl')})
    else:
        return jsonify({
            'message': 'Booking is not available',
            'content': response.content,
            'status_code': response.status_code,
        }), 400
