# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from logging import getLogger

from flask import jsonify

from travel.avia.ticket_daemon.ticket_daemon.daemon.importer import Importer
from travel.avia.ticket_daemon.ticket_daemon.daemon.utils import logit_with, with_closing_db
from travel.avia.ticket_daemon.ticket_daemon.lib.timelines import QueryTimeLines
from travel.avia.ticket_daemon.ticket_daemon.settings import YANDEX_ENVIRONMENT_TYPE


log = getLogger(__name__)


def fetch(query, partners_context):
    for importer in Importer.gen_for_partners(partners_context.partners, query):
        _do_import = logit_with(log.exception, with_closing_db(importer.do_import))
        _do_import()
        partners_context.assign_importer(importer)

    query.timeline.event(QueryTimeLines.events.spawned_importers, {
        'partners_count': len(query.partners),
    })


def jsend_success(data, http_code=200):
    return jsonify({'status': 'success', 'data': data}), http_code


def jsend_fail(data, http_code=400):
    if YANDEX_ENVIRONMENT_TYPE == 'production':
        try:
            # RASPTICKETS-23036
            data.pop('description', None)
        except:
            pass
    return jsonify({'status': 'fail', 'data': data}), http_code


def jsend_error(message, http_code=503):
    return jsonify({'status': 'error', 'message': message}), http_code
