# -*- coding: utf-8 -*-
from logging import getLogger

from django.conf import settings
from flask import Blueprint, Response

from travel.avia.library.python.shared_objects.shared_flag import SharedFlag

log = getLogger(__name__)

service_routes = Blueprint('service routes', __name__)
shared_flag = SharedFlag()


@service_routes.route('/version', methods=['GET'])
def version():
    return Response(settings.PKG_VERSION, mimetype='text/plain')


@service_routes.route('/sentry/check/log/error', methods=['GET'])
def sentry_check_log_error():
    getLogger('sentry_check_log_error').error(
        'Do not worry this is a test error message'
    )
    return 'ok'


@service_routes.route('/sentry/check/log/traceback', methods=['GET'])
def sentry_check_log_traceback():
    return 0/0
