PY2_LIBRARY(ticket-daemon-api)

OWNER(g:avia)

PEERDIR(
    # Avia dependencies
    travel/avia/library/python/avia_data
    travel/avia/library/python/common
    travel/avia/library/python/environment_helpers
    travel/avia/library/python/proxy_pool
    travel/avia/library/python/proxy_pool/django
    travel/avia/library/python/redis
    travel/avia/library/python/route_search
    travel/avia/library/python/safe_lxml
    travel/avia/library/python/shared_objects
    travel/avia/library/python/sirena_client
    travel/avia/library/python/sirena_client/django
    travel/proto/avia/wizard

    # Travel dependencies
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/flask_helpers
    travel/avia/library/python/http_geobase
    travel/avia/library/python/price_prediction
    travel/avia/library/python/ticket_daemon
    travel/avia/library/python/ticket_daemon/caches
    travel/avia/library/python/ticket_daemon/memo
    travel/library/python/avia_mdb_replica_info
    travel/library/python/gunicorn/worker_watcher
    travel/library/python/logbroker
    travel/library/python/solomon
    travel/library/python/tvm_ticket_provider

    # hemi
    travel/rasp/library/python/hemi

    # Yandex dependencies
    ydb/public/sdk/python
    yt/python/client
    yt/yt/python/yt_yson_bindings
    library/python/ylog
    library/python/gunicorn
    library/python/django

    # Tracing dependencies
    contrib/python/Flask-OpenTracing
    contrib/python/jaeger-client
    contrib/python/opentracing
    contrib/python/opentracing-instrumentation
    contrib/python/tornado/tornado-4
    travel/library/python/tracing/flask_opentracing_helpers
    contrib/python/schedule

    # Other dependencies
    contrib/python/attrs
    contrib/python/Babel
    contrib/python/blinker
    contrib/python/boto3
    contrib/python/celery
    contrib/python/ciso8601
    contrib/python/decorator
    travel/avia/library/python/django_namedtuples
    contrib/python/django/django-1.11
    contrib/python/django-redis
    contrib/python/flask-swagger-ui
    contrib/python/Flask
    contrib/python/geoindex
    contrib/python/gevent
    contrib/python/gunicorn
    contrib/python/lxml
    contrib/python/marshmallow/py2
    contrib/python/more-itertools
    contrib/python/MySQL-python
    contrib/python/orderedset
    contrib/python/Pillow
    contrib/python/protobuf
    contrib/python/pyOpenSSL
    contrib/python/Pygments
    contrib/python/PyMySQL
    contrib/python/dateutil
    contrib/python/pytils
    contrib/python/pytz
    contrib/python/raven
    contrib/python/redis
    contrib/python/requests
    contrib/python/retrying
    contrib/python/scour
    contrib/python/setuptools
    contrib/python/service-identity
    contrib/python/six
    contrib/python/statsd
    contrib/python/typing
    contrib/python/ujson
    contrib/python/zeep

    # For good console in manage.py
    contrib/python/ipython
)

PY_SRCS(
    app.py
    gunicorn_conf.py
    ticket_daemon/api/flights.py
    ticket_daemon/api/cache.py
    ticket_daemon/api/min_price_cacher.py
    ticket_daemon/api/models_utils/__init__.py
    ticket_daemon/api/models_utils/cabin_class.py
    ticket_daemon/api/models_utils/company.py
    ticket_daemon/api/models_utils/conversions.py
    ticket_daemon/api/models_utils/country.py
    ticket_daemon/api/models_utils/currency.py
    ticket_daemon/api/models_utils/interfaces/__init__.py
    ticket_daemon/api/models_utils/modern_currency.py
    ticket_daemon/api/models_utils/national_version.py
    ticket_daemon/api/models_utils/partners.py
    ticket_daemon/api/models_utils/point.py
    ticket_daemon/api/models_utils/region.py
    ticket_daemon/api/models_utils/regionalization_rules.py
    ticket_daemon/api/models_utils/registry.py
    ticket_daemon/api/models_utils/search_codes.py
    ticket_daemon/api/models_utils/settlement.py
    ticket_daemon/api/models_utils/station.py
    ticket_daemon/api/models_utils/top_flights.py
    ticket_daemon/api/partners_context.py
    ticket_daemon/api/partners_utils.py
    ticket_daemon/api/query.py
    ticket_daemon/api/redirect.py
    ticket_daemon/api/regionalization.py
    ticket_daemon/api/result/__init__.py
    ticket_daemon/api/result/abstract_result.py
    ticket_daemon/api/result/add_price_prediction.py
    ticket_daemon/api/result/cache_backends.py
    ticket_daemon/api/result/fare_families.py
    ticket_daemon/api/result/filtering.py
    ticket_daemon/api/result/filters/too_fast_moscow_erevan.py
    ticket_daemon/api/result/result.py
    ticket_daemon/api/result/serializer.py
    ticket_daemon/api/selfbook/partner_national_directions.py
    ticket_daemon/api/yaclid.py
    ticket_daemon/application.py
    ticket_daemon/daemon/async_helpers.py
    ticket_daemon/daemon/big_beauty_collector.py
    ticket_daemon/daemon/big_beauty_sorter.py
    ticket_daemon/daemon/celery_revise_app.py
    ticket_daemon/daemon/extended_fares/extended_fares_comparator.py
    ticket_daemon/daemon/extended_fares/fare_extender.py
    ticket_daemon/daemon/flask_helpers.py
    ticket_daemon/daemon/importer.py
    ticket_daemon/daemon/importer_dialog.py
    ticket_daemon/daemon/mysql_switcher/base.py
    ticket_daemon/daemon/mysql_switcher/signals.py
    ticket_daemon/daemon/logbroker.py
    ticket_daemon/daemon/response_collector.py
    ticket_daemon/daemon/tasks.py
    ticket_daemon/daemon/timeout_utils.py
    ticket_daemon/daemon/utils.py
    ticket_daemon/daemon/variants_saver.py
    ticket_daemon/daemon_tester/__init__.py
    ticket_daemon/devtools/__init__.py
    ticket_daemon/management/commands/_loggers.py
    ticket_daemon/management/commands/delete_expired_wizard_experimental_ydb_rows.py
    ticket_daemon/management/commands/delete_expired_wizard_ydb_rows.py
    ticket_daemon/management/commands/delete_expired_ydb_rows.py
    ticket_daemon/management/commands/run_partner_module.py
    ticket_daemon/models/__init__.py
    ticket_daemon/scripts/refresh_currency_converter_cache.py
    ticket_daemon/scripts/send_tracks_to_emulator.py
    ticket_daemon/settings/__init__.py
    ticket_daemon/settings/application.py
    ticket_daemon/settings/caches.py
    ticket_daemon/settings/celery.py
    ticket_daemon/settings/currencies.py
    ticket_daemon/settings/db.py
    ticket_daemon/settings/django.py
    ticket_daemon/settings/environment.py
    ticket_daemon/settings/filters.py
    ticket_daemon/settings/frontend.py
    ticket_daemon/settings/locale.py
    ticket_daemon/settings/logs.py
    ticket_daemon/settings/partner.py
    ticket_daemon/settings/price_prediction.py
    ticket_daemon/settings/proxy.py
    ticket_daemon/settings/sqs.py
    ticket_daemon/settings/ydb.py
    ticket_daemon/views/__init__.py
    ticket_daemon/views/book_view.py
    ticket_daemon/views/helpers.py
    ticket_daemon/views/init_query_views.py
    ticket_daemon/views/redirect_views.py
    ticket_daemon/views/service_views.py
    ticket_daemon/views/track_views.py
    tools/tickets_query_partner.py
    wsgi.py
)

RESOURCE_FILES(
    PREFIX travel/avia/ticket_daemon/
    ticket_daemon/templates/debug/configure.html
    ticket_daemon/templates/partners/aeroflot2.xml
    ticket_daemon/templates/partners/aeroflot.xml
    ticket_daemon/templates/partners/biletix.xml
    ticket_daemon/templates/partners/bravoavia.xml
    ticket_daemon/templates/partners/nabortu_aviasearch_request.xml
    ticket_daemon/templates/partners/nabortu.xml
    ticket_daemon/templates/partners/nemo2.xml
    ticket_daemon/templates/partners/nemo.xml
    ticket_daemon/templates/partners/sirena_mono_brand.xml
    ticket_daemon/templates/partners/sirena_pricing_route.xml
    ticket_daemon/templates/partners/sig.xml
    ticket_daemon/templates/partners/s_seven3.xml
    ticket_daemon/templates/partners/s_seven4.xml
    ticket_daemon/templates/partners/s_seven5.xml
    ticket_daemon/templates/partners/s_seven6.xml
    ticket_daemon/templates/partners/s_seven_testing.xml
    ticket_daemon/templates/partners/supersaver.xml
    ticket_daemon/templates/partners/tripsta5.xml
    ticket_daemon/templates/partners/utair.xml
)

PEERDIR(
    travel/avia/library/python/ticket_daemon/date
    travel/avia/library/python/ticket_daemon/decorators
    travel/avia/library/python/ticket_daemon/ydb
    travel/avia/library/python/ticket_daemon/ydb/banned_variants
    travel/avia/library/python/ticket_daemon/ydb/django
    travel/avia/ticket_daemon/ticket_daemon/lib
    travel/avia/ticket_daemon/ticket_daemon/lib/sirena
    travel/avia/ticket_daemon/ticket_daemon/lib/ydb
    travel/avia/ticket_daemon/ticket_daemon/lib/yt_loggers
    travel/avia/ticket_daemon/ticket_daemon/partners
)

END()

RECURSE(
    ticket_daemon
)

RECURSE_FOR_TESTS(
    tests
)

RECURSE(
    bin
)
