import json
import os
import urllib2

MCROUTER_PORT = '11211'
CONFIG_PATH = '/etc/mcrouter/pools'
ENVIRONMENTS = ('testing', 'production')


def _request(env):
    headers = {
        'Authorization': 'OAuth {}'.format(os.getenv('QLOUD_API_OAUTH_TOKEN')),
        'Content-type': 'application/json',
    }
    url = 'https://platform.yandex-team.ru/api/v1/environment/stable/avia.memcached.{env}'
    request = urllib2.Request(url.format(env=env), headers=headers)
    response = urllib2.urlopen(request)
    status_code = response.getcode()
    content = response.read()
    if status_code != 200:
        raise RuntimeError('Bad code %s. content: %s' % (status_code, content))
    return json.loads(content)


def update_pools(env):
    pools = {
        'iva': {
            'servers': set(),
        },
        'myt': {
            'servers': set(),
        },
        'sas': {
            'servers': set(),
        },
        'vla': {
            'servers': set(),
        },
        'man': {
            'servers': set(),
        },
    }

    response = _request(env)
    for dc, component_info in response['components'].items():
        for instance in component_info['runningInstances']:
            host = '{instance_id}.{dc}.{env}.memcached.avia.stable.qloud-d.yandex.net'.format(
                instance_id=instance['instanceId'], dc=dc, env=env
            )
            pools.setdefault(dc, {'servers': set()}).get('servers').add(host + ':' + MCROUTER_PORT)

    for dc in pools:
        pools[dc]['servers'] = sorted(list(pools[dc]['servers']))

    # fill for backward compatibility
    if 'vla' not in pools:
        pools['vla'] = pools.get('myt') or pools.get('iva') or pools.get('sas')
    if 'iva' not in pools:
        pools['iva'] = pools.get('myt') or pools.get('vla') or pools.get('sas')

    with open(os.path.join(CONFIG_PATH, env + '.conf'), 'w') as fp:
        json.dump(pools, fp, indent=4)


if __name__ == '__main__':
    env = os.getenv('YANDEX_ENVIRONMENT_TYPE')
    if env in ENVIRONMENTS:
        print('run updating %s pools' % env)
        update_pools(env)
    if env not in ENVIRONMENTS:
        print('"%s" not in %r' % (env, ENVIRONMENTS))
    print('Done')
