# coding: utf8
import re

from base_util import nginx_log_normalize_uri

PATHS = [
    (r'keys$', None),
    (r'ping', None),
    (r'shutdown', None),
    (r'jsendapi/avia_api/init_search', '/jsendapi/avia_api/init_search'),
    (r'jsendapi/avia_api/results', '/jsendapi/avia_api/results'),
    (r'jsendapi/decode_yaclid', '/jsendapi/decode_yaclid'),
    (r'jsendapi/front/init_search_by_query', '/jsendapi/front/init_search_by_query'),
    (r'jsendapi/init_search', '/jsendapi/init_search'),
    (r'jsendapi/rasp/results_by_qid', '/jsendapi/rasp/results_by_qid'),
    (r'jsendapi/rasp/results_by_search_params', '/jsendapi/rasp/results_by_search_params'),
    (r'jsendapi/td_processing/v1/results', '/jsendapi/td_processing/v1/results'),
    (r'jsendapi/v3/invalidate_variant', '/jsendapi/v3/invalidate_variant'),
    (r'jsendapi/v3/order', '/jsendapi/v3/order'),
    (r'jsendapi/v3/redirect', '/jsendapi/v3/redirect'),
    (r'jsendapi/v3/results', '/jsendapi/v3/results'),
    (r'jsendapi/v3/wizard_results', '/jsendapi/v3/wizard_results'),
    (r'jsendapi/wizard/v1/big_wizard_results_and_filters', '/jsendapi/wizard/v1/big_wizard_results_and_filters'),
]

NV_PATHS = frozenset(('/jsendapi/v3/results', '/jsendapi/v3/order', '/jsendapi/v3/redirect', '/jsendapi/front/init_search_by_query'))


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(PATHS, uri)


def nginx_log_normalize_record(record):
    path = nginx_log_normalize_path(record.uri)
    if path in NV_PATHS:
        match = re.search('(national=(ru|com|ua|kz|tr))', record.args)
        if match:
            return '%s?%s' % (path, match.group())
    return path
