# -*- coding: utf-8 -*-

from django.utils.http import urlencode
from django.conf import settings

from travel.avia.ticket_daemon_api.jsonrpc.lib.tariff_serializer import TariffSerializer


def avia_deep_link(query, v, clid=None):
    host_by_national_version = settings.AVIA_HOST_BY_NATIONAL_VERSION
    travel_host_by_national_version = settings.TRAVEL_HOST_BY_NATIONAL_VERSION

    params = {
        'forward': v['forward']['key2'],
        'partner': v['partner_code'],
        'qid': query.id,
        'lang': query.lang or settings.DEFAULT_NATIONAL_VERSION_LANGUAGES.get(query.national_version),
        'tariff_sign': TariffSerializer.serialize(v['tariff'], v.get('created')),
    }
    if clid is not None:
        params['clid'] = clid
    if v['backward']:
        params['backward'] = v['backward']['key2']

    if query.national_version in travel_host_by_national_version:
        return 'https://{host}/avia/redirect/?{params}'.format(
            host=travel_host_by_national_version[query.national_version],
            params=urlencode(params),
        )

    return 'https://{host}/order/redirect/?{params}'.format(
        host=host_by_national_version.get(query.national_version, host_by_national_version['ru']),
        params=urlencode(params),
    )


def avia_order_link(query, v, clid=None):
    host_by_national_version = settings.AVIA_HOST_BY_NATIONAL_VERSION
    travel_host_by_national_version = settings.TRAVEL_HOST_BY_NATIONAL_VERSION

    params = {
        'toId': query.point_to.point_key,
        'fromId': query.point_from.point_key,
        'when': query.date_forward.strftime('%Y-%m-%d'),
        'forward': v['forward']['key2'],
        'lang': query.lang,
        'qid': query.id,
    }
    if clid is not None:
        params['clid'] = clid

    if query.date_backward:
        params['return_date'] = query.date_backward.strftime('%Y-%m-%d')
        params['backward'] = v['backward']['key2']

    national_version = query.national_version or 'ru'
    if national_version in travel_host_by_national_version:
        host = travel_host_by_national_version[national_version]
        order_link_template = 'https://{host}/avia/order/?{params}'
    else:
        host = host_by_national_version[national_version]
        order_link_template = 'https://{host}/order/?{params}'

    return order_link_template.format(host=host, params=urlencode(params))
