# -*- coding: utf-8 -*-
from marshmallow import fields

from travel.avia.ticket_daemon_api.jsonrpc.handlers.scheme import (
    clean_resultpages, clean_tags, clean_skippartners
)
from travel.avia.ticket_daemon_api.jsonrpc.schemas.reference_front import TypeSchema


class AviaApiSearchResultsInputSchema(TypeSchema):
    qid = fields.String(required=True)
    currency = fields.String(required=True)
    skip = fields.Function(deserialize=clean_skippartners, missing=list)
    result_pages = fields.Function(deserialize=clean_resultpages, missing=dict)
    tags = fields.Function(deserialize=clean_tags, missing=list)
    clid = fields.Int(missing=0)
