# -*- coding: utf-8 -*-
from marshmallow import Schema, fields

from travel.avia.ticket_daemon_api.jsonrpc.handlers.scheme import (
    clean_resultpages, clean_skippartners, QidInputSchema, QueryParamsSchema
)


class SearchResultsBaseSchema(Schema):
    lang = fields.String(required=True)
    skip_partners = fields.Function(deserialize=clean_skippartners, missing=list)
    resultpages = fields.Function(deserialize=clean_resultpages, missing=dict)


class _RaspResultsBase(SearchResultsBaseSchema):
    t_code = fields.String(
        missing='plane',
        validate=fields.validate.OneOf(['plane', 'train', 'bus', 'blablacar'])
    )
    full_results = fields.Boolean(required=False, missing=False)


class ResultsInputSchema(_RaspResultsBase, QidInputSchema):
    """"""


class QueryResultsInputSchema(_RaspResultsBase, QueryParamsSchema):
    """"""
