# -*- coding: utf-8 -*-
import logging

from flask import Blueprint, request
from werkzeug.exceptions import BadRequest

from travel.avia.ticket_daemon_api.jsonrpc.handlers.v3.serialization import (
    complete_results, serialize_results
)
from travel.avia.ticket_daemon_api.jsonrpc.lib import result as resultlib
from travel.avia.ticket_daemon_api.jsonrpc.schemas.base import QidInputSchema
from travel.avia.ticket_daemon_api.jsonrpc.views import jsend_view, clean_query_from_qid

log = logging.getLogger(__name__)

td_processing_api = Blueprint('td_processing', __name__)


@td_processing_api.route('/results/<qid>')
@jsend_view
def td_processing_results(**kwargs):
    params, errors = QidInputSchema().load(
        dict(request.values.items(), **kwargs)
    )
    if errors:
        log.warning('td_processing_results. Params are not valid: %r', errors)
        raise BadRequest({'errors': errors})
    return _td_processing_results(params)


def _td_processing_results(params):
    q = clean_query_from_qid(params['qid'])

    results, statuses, _ = resultlib.collect_variants(
        q,
        mode=resultlib.CollectingModes.actual,
    )

    datum = complete_results(results, params, q)
    return serialize_results(datum, q)
