# -*- coding: utf-8 -*-
import ujson

from marshmallow import Schema, fields, pre_load, post_load

from travel.avia.ticket_daemon_api.jsonrpc.handlers.scheme import QueryParamsSchema


class TransferFilterSchema(Schema):
    count = fields.Integer(missing=None)
    min_duration = fields.Integer(missing=None, load_from='minDuration')
    max_duration = fields.Integer(missing=None, load_from='maxDuration')
    has_airport_change = fields.Boolean(missing=None, load_from='hasAirportChange')
    has_night = fields.Boolean(missing=None, load_from='hasNight')


class TimeFilterSchema(Schema):
    """
    DateTime для простой валидации формата,
    сравниваем в итоге строки в лексикографическом порядке, приводим сразу тут
    """
    forward_departure_min = fields.DateTime(missing=None, load_from='forwardDepartureMin')
    forward_departure_max = fields.DateTime(missing=None, load_from='forwardDepartureMax')
    forward_arrival_min = fields.DateTime(missing=None, load_from='forwardArrivalMin')
    forward_arrival_max = fields.DateTime(missing=None, load_from='forwardArrivalMax')
    backward_departure_min = fields.DateTime(missing=None, load_from='backwardDepartureMin')
    backward_departure_max = fields.DateTime(missing=None, load_from='backwardDepartureMax')
    backward_arrival_min = fields.DateTime(missing=None, load_from='backwardArrivalMin')
    backward_arrival_max = fields.DateTime(missing=None, load_from='backwardArrivalMax')

    @post_load
    def _reformat_datetime(self, data):
        return {k: v.strftime('%Y-%m-%dT%H:%M:%S') if v else v for k, v in data.iteritems()}


class AirportsFilterSchema(Schema):
    forward_departure = fields.List(fields.Integer(), missing=None, load_from='forwardDeparture')
    forward_arrival = fields.List(fields.Integer(), missing=None, load_from='forwardArrival')
    backward_departure = fields.List(fields.Integer(), missing=None, load_from='backwardDeparture')
    backward_arrival = fields.List(fields.Integer(), missing=None, load_from='backwardArrival')
    forward_transfers = fields.List(fields.Integer(), missing=None, load_from='forwardTransfers')
    backward_transfers = fields.List(fields.Integer(), missing=None, load_from='backwardTransfers')


class FiltersSchema(Schema):
    with_baggage = fields.Bool(missing=None, load_from='withBaggage')
    transfer_filters = fields.Nested(
        TransferFilterSchema(), missing=None, load_from='transfer'
    )
    time_filters = fields.Nested(
        TimeFilterSchema(), missing=None, load_from='time'
    )
    airlines = fields.List(fields.Integer(), missing=None)
    airports_filters = fields.Nested(
        AirportsFilterSchema(), missing=None, load_from='airport'
    )

    @pre_load
    def deserialize(self, data):
        return ujson.loads(data) if data else {}


class SliceSchema(Schema):
    limit = fields.Integer(required=False)
    offset = fields.Integer(required=False)


class WizardFullResultsSchema(QueryParamsSchema, SliceSchema):
    filters = fields.Nested(FiltersSchema)
    experimental_sort = fields.String(required=False, missing=None)
