# -*- coding: utf-8 -*-
import logging

from flask import Blueprint, request
from werkzeug.exceptions import BadRequest

from travel.avia.library.python.ticket_daemon.protobuf_converting.big_wizard.search_result_converter import SearchResultConverter
from travel.avia.library.python.ticket_daemon.protobuf_converting.big_wizard.filtering import search_result_filtering

from travel.avia.ticket_daemon_api.jsonrpc.lib import result as resultlib
from travel.avia.ticket_daemon_api.jsonrpc.query import Query
from travel.avia.ticket_daemon_api.jsonrpc.views import jsend_view
from travel.avia.ticket_daemon_api.jsonrpc.handlers.wizard.scheme import (
    WizardFullResultsSchema, QueryParamsSchema
)

log = logging.getLogger(__name__)

wizard_api = Blueprint('wizard_api', __name__)


@wizard_api.route('/big_wizard_results_and_filters')
@jsend_view
def big_wizard_results_and_filters():
    params, errors = WizardFullResultsSchema().load(request.values)
    if errors:
        log.warning(
            '/big_wizard_results_and_filters. Params are not valid: %r',
            errors)
        raise BadRequest({'errors': errors})
    return _big_wizard_results_and_filters(params)


@wizard_api.route('/big_wizard_results')
@jsend_view
def big_wizard_results():
    params, errors = WizardFullResultsSchema().load(request.values)
    if errors:
        log.warning('/big_wizard_results. Params are not valid: %r', errors)
        raise BadRequest({'errors': errors})
    return _big_wizard_results(params)


@wizard_api.route('/big_wizard_filters')
@jsend_view
def big_wizard_filters():
    params, errors = QueryParamsSchema().load(request.values)
    if errors:
        log.warning('/big_wizard_filters. Params are not valid: %r', errors)
        raise BadRequest({'errors': errors})
    return _big_wizard_filters(params)


def _big_wizard_results_and_filters(params):
    q = Query(**params)
    datum = resultlib.collect_big_beauty_results_and_filters(q, params.get('experimental_sort'))

    if datum:
        search_result_filtering.filter_and_slice(datum['result'], params)
        datum['result'] = SearchResultConverter().to_dictionary(
            datum['result'])
    return datum


def _big_wizard_results(params):
    q = Query(**params)
    search_result = resultlib.collect_big_beauty(q, params.get('experimental_sort'))

    if search_result:
        search_result_filtering.filter_and_slice(search_result, params)
        return SearchResultConverter().to_dictionary(search_result)
    else:
        return search_result


def _big_wizard_filters(params):
    q = Query(**params)
    return resultlib.collect_big_beauty_filters(q)
