# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
from collections import namedtuple

import django.db

from travel.avia.library.python.ticket_daemon.memo import CacheWithKeyTTL, memoize

log = logging.getLogger(__name__)

PingCheckInfo = namedtuple('PingCheckInfo', ('disable_flag', 'checker'))


class HealthError(Exception):
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return '<{} message={}/>'.format(
            self.__class__.__name__,
            self.message
        )


class MysqlServerError(HealthError):
    pass


class MysqlChecker(object):
    def __init__(self, connection):
        self._connection = connection

    @memoize(keyfun=lambda _self: None, cache=CacheWithKeyTTL(10))
    def check(self):
        try:
            with self._connection.cursor() as cursor:
                cursor.execute('select now()')
                cursor.fetchone()
            return 'alive'
        except Exception as e:
            raise MysqlServerError(e)


available_ping_checks = [
    PingCheckInfo('disable-mysql-check', MysqlChecker(django.db.connection)),
]
