# -*- coding: utf-8 -*-
from collections import OrderedDict

from travel.avia.ticket_daemon_api.environment import YANDEX_ENVIRONMENT_TYPE


class Jsend(OrderedDict):
    def __init__(self, status_code):
        self.status_code = status_code
        super(Jsend, self).__init__()

    def to_dict(self):
        return self


class JsendSuccess(Jsend):
    DEFAULT_STATUS_CODE = 200

    def __init__(self, data, status_code=DEFAULT_STATUS_CODE):
        super(JsendSuccess, self).__init__(status_code)
        self['status'] = 'success'
        self['data'] = data


class JsendFail(Jsend):
    DEFAULT_STATUS_CODE = 400

    def __init__(self, data, status_code=DEFAULT_STATUS_CODE):
        super(JsendFail, self).__init__(status_code)
        self['status'] = 'fail'
        if YANDEX_ENVIRONMENT_TYPE == 'production':
            try:
                # RASPTICKETS-23036
                data.pop('description', None)
            except:
                pass
        self['data'] = data


class JsendError(Jsend):
    DEFAULT_STATUS_CODE = 500

    def __init__(self, message, status_code=DEFAULT_STATUS_CODE):
        super(JsendError, self).__init__(status_code)
        self['status'] = 'error'
        self['message'] = message
