import re
from itertools import chain

KEY_PARTS = re.compile(r'((\d{0,2})([pdN]))')


def info_from_key(key):
    fields = ('included', 'pc', 'wt')
    if not key:
        return dict.fromkeys(fields)
    baggage = {}
    for (_, count, source), field in zip(KEY_PARTS.findall(key), fields):
        baggage[field] = {
            'count': int(count),
            'source': 'partner' if source == 'p' else 'db'
        } if source != 'N' else None
    return baggage


def with_baggage(baggage):
    """
    :param baggage: Example - [['1d1d23d'], ['1p1p15p', '1p1pN']]
    :rtype: bool
    """
    return all(b and b.startswith('1') for b in chain.from_iterable(baggage))
