# -*- coding: utf-8 -*-
import logging
import zlib

import ujson as json
from django.core.cache import caches

from travel.avia.library.python.common.utils.memcache_backend import MemcachedCache
from travel.avia.library.python.ticket_daemon.decorators import log_elapsed_time

logger = logging.getLogger(__name__)


def decorate_methods(methods, decorator):
    def decorate(cls):
        for method in methods:
            setattr(cls, method, decorator(getattr(cls, method)))
        return cls

    return decorate


@decorate_methods(('set', 'get', 'set_many', 'get_many'), log_elapsed_time(logger))
class LoggingMemcachedCache(MemcachedCache):
    """
    Бэкенд для memcache, логирующий времена set, get
    """

    def unpack(self, packed):
        return json.loads(zlib.decompress(packed))


default_cache = caches['default']
shared_cache = caches['shared_cache']
