# -*- coding: utf-8 -*-
from functools import update_wrapper, wraps


def pipe(sink):
    """Пропустит результат через функцию sink"""
    def deco(fn):
        @wraps(fn)
        def wrapper(*args, **kwargs):
            return sink(fn(*args, **kwargs))
        return wrapper
    return deco


# Copy of django.utils.decorators.method_decorator
def method_decorator(dec_orig):
    """
    Converts a function decorator into a method decorator
    """
    # 'func' is a function at the time it is passed to _dec, but will
    # eventually be a method of the class it is defined it.
    def _dec(func):
        def _wrapper(self, *args, **kwargs):
            @dec_orig
            def bound_func(*args2, **kwargs2):
                return func(self, *args2, **kwargs2)
            # bound_func has the signature that 'dec_orig' expects i.e.  no
            # 'self' argument, but it is a closure over self so it can call
            # 'func' correctly.
            return bound_func(*args, **kwargs)
        # In case 'dec_orig' adds attributes to the function it decorates, we
        # want to copy those. We don't have access to bound_func in this scope,
        # but we can cheat by using it on a dummy function.

        @dec_orig
        def dummy(*args, **kwargs):
            pass
        update_wrapper(_wrapper, dummy)
        # Need to preserve any existing attributes of 'func',
        # including the name.
        update_wrapper(_wrapper, func)

        return _wrapper
    update_wrapper(_dec, dec_orig)
    # Change the name to aid debugging.
    _dec.__name__ = 'method_decorator(%s)' % dec_orig.__name__
    return _dec
