# -*- coding: utf-8 -*-

import os.path

from library.python import resource

XML_TEMPLATE = """<FareDetail>
    <Leg>
        <Seg>
            <FareCodePrefix>{FareCodePrefix}</FareCodePrefix>
            <FromCountry>{FromCountry}</FromCountry>
            <ToCountry>{ToCountry}</ToCountry>
            <FromAirport>{FromAirport}</FromAirport>
            <ToAirport>{ToAirport}</ToAirport>
            <ArrivalTs>{ArrivalTs}</ArrivalTs>
        </Seg>
        <CountryOfSale>RU</CountryOfSale>
        <FareBasis>
            <FareBasisCode>
            <Code>{Code}</Code>
            </FareBasisCode>
        </FareBasis>
    </Leg>
</FareDetail>"""

_BASE_PATH = os.path.join('resfs/file', 'travel', 'avia', 'ticket_daemon_api', 'data')
FARE_FAMILIES_PATH = os.path.join(_BASE_PATH, 'fare_families')
FARE_FAMILIES_EXPRESSIONS_PATH = os.path.join(_BASE_PATH, 'fare_families_expressions')


def get_all_resources(path):
    if path and not path.endswith('/'):
        # иначе из resource.iterkeys получим '/29_utair.json' вместо '29_utair.json'
        path += '/'
    return {r: os.path.join(path, r) for r in resource.iterkeys(path, strip_prefix=True)}
