from __future__ import unicode_literals
import hashlib
from datetime import datetime
from urllib import urlencode

from typing import Any, List

from django.conf import settings


class IATAFlight(object):
    @staticmethod
    def make_flight_tag(local_departure, number):
        # type: (datetime, unicode) -> unicode
        return '{}{}'.format(
            local_departure.strftime('%y%m%d%H%M') if local_departure else '',
            number.replace(' ', '')
        )

    @staticmethod
    def url(number, departure, national_version, params=None):
        # type: (unicode, Any[dict, str, None], Any[str, unicode], dict) -> unicode
        if params is None:
            params = {}
        if departure:
            if isinstance(departure, dict):
                if isinstance(departure['local'], basestring):
                    params['when'] = departure['local'][:10]
                else:
                    params['when'] = departure['local'].strftime('%Y-%m-%d')
            else:
                params['when'] = departure

        if isinstance(number, str):
            number = number.decode('utf-8')

        avia_hosts = settings.AVIA_HOST_BY_NATIONAL_VERSION
        travel_hosts = settings.TRAVEL_HOST_BY_NATIONAL_VERSION
        if national_version in travel_hosts:
            url = 'https://{}/avia/flights/{}/'.format(
                travel_hosts[national_version],
                number.replace(' ', '-'),
            )
        else:
            url = 'https://{}/flights/{}/'.format(
                avia_hosts.get(national_version, avia_hosts.get('ru')),
                number.replace(' ', '-'),
            )

        if params:
            url += '?' + urlencode(params)

        return url


class Variant(object):
    @staticmethod
    def make_tag(forward_tags, backward_tags, klass, partner_code, with_baggage):
        # type: (List[unicode], List[unicode], unicode, unicode, bool) -> str
        tag_data = [
            '|'.join(forward_tags), '|'.join(backward_tags),
            klass, partner_code, with_baggage
        ]
        tag_text = '{}@{}@{}@{}@{}'.format(*tag_data)

        return hashlib.md5(tag_text.encode('utf-8')).hexdigest()
