# -*- coding: utf-8 -*-
import urlparse

from django.utils.http import urlencode


def update_query_string(url, params):
    url_parts = list(urlparse.urlparse(url))
    query = dict(urlparse.parse_qsl(url_parts[4], keep_blank_values=True))
    query.update(params)
    url_parts[4] = urlencode(query)

    return urlparse.urlunparse(url_parts)


def dirty_add_to_query_string(url, params):
    url_parts = list(urlparse.urlparse(url))
    url_parts[4] += ('&' if url_parts[4] and params else '') + urlencode(params)
    return urlparse.urlunparse(url_parts)
