import os

YT_LOGGERS = ('yt.api_variants',)


def create_logging_setting(log_path, yt_log_path, yandex_environment_type):
    logging_dict = {
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'level': 'INFO',
            'handlers': ['main_tree', 'error', 'traceback'],
        },
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s: %(message)s'
            },
            'message_only': {
                'format': '%(message)s'
            },
            'error': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
                'full': True,
                'show_locals': True
            },
        },
        'handlers': {
            'sentry': {
                'level': 'ERROR',
                'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
                'tags': {
                    'environment': os.getenv('YANDEX_ENVIRONMENT_TYPE', 'unknown'),
                    'DEPLOY_NODE_DC': os.getenv('DEPLOY_NODE_DC'),
                    'DEPLOY_STAGE_ID': os.getenv('DEPLOY_STAGE_ID'),
                },
            },
            'error': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'main', 'error.log'),
                'formatter': 'error',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'main', 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            },
            'main_tree': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'verbose',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
            'main_tree_debug': {
                'level': 'DEBUG',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'verbose',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
            'tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': log_path,
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
            'main_tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'main'),
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
            'root_tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': log_path,
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
            'yt_tree_handler_message_only': {
                'level': 'INFO',
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': yt_log_path,
                'formatter': 'message_only',
                'remove_prefix': 'travel.avia.ticket_daemon_api',
            },
        },
        'loggers': {
            'dcutils': {
                'handlers': ['main_tree_handler_message_only'],
                'level': 'INFO',
                'propagate': False,
            },
        }
    }

    for yt_logger in YT_LOGGERS:
        logging_dict['loggers'][yt_logger] = {
            'handlers': ['yt_tree_handler_message_only'],
            'level': 'INFO',
            'propagate': False,
        }

    if yandex_environment_type in ['development']:
        logging_dict['root'] = {
            'handlers': ['main_tree_debug', 'error', 'traceback'],
            'level': 'DEBUG',
        }

    if yandex_environment_type in ['testing', 'production', 'development']:
        logging_dict['root']['handlers'].append('sentry')

    return logging_dict
