# coding=utf-8

from travel.avia.ticket_daemon_api.jsonrpc.models_utils.order import get_partner_by_code


class PartnerStoreTimeProvider(object):
    def get_status_time(self, partner_code):
        # type: (str) -> int
        """
        Возвращает время на которое был сохранен статус в секундах
        """
        # TODO: если store_time будет разъезжаться с записанным в TD, нужно взять из memcache
        store_time = self._get_cache_time(partner_code)
        return max(store_time, 5) * 60

    def get_result_time(self, partner_code):
        # type: (str) -> int
        """
        Возвращает время на которое был сохранен результат в секундах
        """
        return self.get_status_time(partner_code) + 5 * 60

    def _get_cache_time(self, partner_code):
        partner = get_partner_by_code(partner_code)
        return partner.get_variant_cache_ttl()


partner_store_time_provider = PartnerStoreTimeProvider()
