# -*- coding: utf-8 -*-
import urllib
from logging import getLogger
from urlparse import urlsplit, urlunsplit

log = getLogger(__name__)


def url_add_openstat_marker(url, partner_code, host, domain):
    if partner_code in ['glavbilet', 'ufs', 'tickets_ua']:
        return url

    if partner_code.startswith('dohop') or partner_code.startswith('amadeus'):
        return url

    o = urlsplit(url)

    marker = u"ticket.yandex.%s;%s;Купить Авиабилет;%s" % \
        (domain, partner_code, host)

    query = (o.query + '&' if o.query else '') + \
        '_openstat=' + urllib.quote(marker.encode('utf-8'), safe='')

    return urlunsplit((o.scheme, o.netloc, o.path, query, o.fragment))
