# -*- coding: utf-8 -*-
import time


class RequestTimer(object):
    def __init__(self, request_timeout):
        self._request_timeout = request_timeout
        self._end_request = time.time() + request_timeout

    def get_available_timeout(self, external_request_timeout=None):
        available_request_time = self._end_request - time.time()
        if external_request_timeout is None:
            return available_request_time

        available_timeout = min([available_request_time, external_request_timeout])
        return max([available_timeout, 0.0])
