# -*- coding: utf-8 -*-
from logging import getLogger

import ujson

from travel.avia.ticket_daemon_api.jsonrpc.lib.result import BigBeautyResult
from travel.avia.ticket_daemon_api.jsonrpc.lib.saas import BigBeautyCache
from travel.proto.avia.wizard.search_result_pb2 import SearchResult

log = getLogger(__name__)


def deserialize_result(doc, column):
    if column not in doc:
        log.warning("Suddenly did not found column '%s' in doc.", column)
        return None
    serialized_result = doc[column]
    search_result = SearchResult()
    search_result.ParseFromString(serialized_result)
    return search_result


def collect_big_beauty(query, experimental_sort=None):
    column_with_variants = (
        experimental_sort
        if experimental_sort in BigBeautyCache.AVAILABLE_SORTS
        else BigBeautyCache.DEFAULT_COLUMN_WITH_VARIANTS
    )
    key = BigBeautyResult.make_key(query.qkey, query.national_version)
    doc = BigBeautyCache.get(key, columns=(column_with_variants,))

    if doc is None:
        return {}

    return deserialize_result(doc, column_with_variants)


def collect_big_beauty_filters(query):
    _column = BigBeautyCache.FILTER_STATE_COLUMN
    key = BigBeautyResult.make_key(query.qkey, query.national_version)
    doc = BigBeautyCache.get(key, columns=(_column,))
    return ujson.loads(doc[_column]) if doc else {}


def collect_big_beauty_results_and_filters(query, experimental_sort=None):
    column_with_variants = (
        experimental_sort
        if experimental_sort in BigBeautyCache.AVAILABLE_SORTS
        else BigBeautyCache.DEFAULT_COLUMN_WITH_VARIANTS
    )
    _columns = (
        column_with_variants, BigBeautyCache.FILTER_STATE_COLUMN,
    )

    key = BigBeautyResult.make_key(query.qkey, query.national_version)
    doc = BigBeautyCache.get(key, columns=_columns)

    return {
        'filters': ujson.loads(doc[BigBeautyCache.FILTER_STATE_COLUMN]),
        'result': deserialize_result(doc, column_with_variants),
    } if doc else {}
