# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon_api.jsonrpc.lib.caches import shared_cache
from travel.avia.ticket_daemon_api.jsonrpc.lib.result.collector.utils import safe_deserialize_packed
from travel.avia.ticket_daemon_api.jsonrpc.lib.result import Status

log = getLogger(__name__)


def collect_statuses(query_key, enabled_partner_codes):
    """

    :param query_key:
    :param enabled_partner_codes:
    :return dict: return statuses for all requested ~enabled_partner_codes~.
       None for empty statuses or saved status json if status is actual
       Example: {'ozon': None, 'csa': None, 'svyaznoy': {--- Status dict ---}, ...}
    """
    status_key_by_partner = {
        partner_code: Status.make_result_key(query_key, partner_code)
        for partner_code in enabled_partner_codes
    }

    packed_items = shared_cache.get_many(status_key_by_partner.values())

    return {
        partner_code: safe_deserialize_packed(packed_items[status_key], log)
        if status_key in packed_items else None
        for partner_code, status_key in status_key_by_partner.iteritems()
    }
