# -*- coding: utf-8 -*-
import logging
import zlib
import ujson as json


def _deserialize(packed):
    return json.loads(zlib.decompress(packed))


def safe_deserialize_packed(packed, log=None):
    try:
        return _deserialize(packed)
    except Exception:
        if not log:
            log = logging.getLogger(__name__)
        log.exception(u'Deserialize status error')
