# -*- coding: utf-8 -*-
from logging import getLogger

from django.conf import settings

log = getLogger(__name__)


class Statuses(object):
    QUERYING = 'querying'
    DONE = 'done'
    SKIP = 'skip'
    EMPTY = 'empty'
    NONE = 'none'
    FAIL = 'fail'
    OUTDATED = 'outdated'

    _in_progress = {QUERYING, OUTDATED}
    _done = {FAIL, SKIP, DONE}

    @classmethod
    def in_progress(cls, status):
        return status in cls._in_progress

    @classmethod
    def is_done(cls, status):
        return status in cls._done


class Result(object):
    @staticmethod
    def make_result_key(qid, partner_code):
        return '{}{}/any/{}'.format(
            settings.TICKET_DAEMON_CACHEROOT,
            qid.replace('.', '/'),
            partner_code
        )


class SaasResult(object):
    @staticmethod
    def make_result_key(qkey, partner_code):
        return '{}/any/{}'.format(qkey, partner_code)


class Status(object):
    @staticmethod
    def make_result_key(qkey, partner_code):
        return '%s%s_%s_%s_status' % (
            settings.TICKET_DAEMON_CACHEROOT,
            qkey,
            'any',
            partner_code,
        )


class RedirectData(object):
    @staticmethod
    def make_key(qkey, lang, partner_code):
        return '{}{}/{}/{}_redirect_data'.format(
            settings.TICKET_DAEMON_CACHEROOT,
            qkey,
            lang,
            partner_code
        )


class BigBeautyResult(object):
    @staticmethod
    def make_key(qkey, lang):
        return '{}{}/{}_big_beauty'.format(
            settings.TICKET_DAEMON_CACHEROOT,
            qkey,
            lang
        )
