# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon_api.jsonrpc.lib.yt_loggers.yt_logger import YtLogger


class ApiVariantsLogger(object):
    def __init__(self, name, environment):
        self._name = name
        self._environment = environment

    def log(self, query, api_results, continuation, completed_partners, statuses):
        """

        :type query: jsonrpc.query.Query
        :type api_results: typing.Dict[unicode,jsonrpc.lib.result.collector.variants_fabric.ApiVariants]
        :type continuation: jsonrpc.handlers.v3.continuation.ContDetails
        :type completed_partners: typing.List[basestring]
        :type statuses: typing.Dict[unicode,unicode]
        """
        log_variants = []

        for p_code, vs in api_results.iteritems():
            for variant in vs.variants:
                log_variants.append({
                    'tag': variant['tag'],
                    'route': variant['route'],
                    'created': variant['created'],
                    'partner': p_code,
                    'tariff': variant['tariff'],
                })

        logger = self._get_process_logger()

        logger.log(
            {
                'qid': query.id,
                'variants': log_variants,
                'cont': continuation.cont,
                'partners': completed_partners,
                'statuses': statuses,
            }
        )

    def _get_process_logger(self):
        # type: () -> YtLogger
        return YtLogger.get_or_create_yt_process_logger(self._name, self._environment)


api_variants_logger = ApiVariantsLogger(name='yt.api_variants', environment=environment)
