# -*- coding: utf-8 -*-
import os
import logging

import ujson


class YtLogger(object):
    """
    Обертка над logging.Logger, позволяющая логгировать записи в json формате
    """
    LOGGER_REGISTRY = {}

    def __init__(self, name, environment):
        self._logger = logging.getLogger(name)
        self._environment = environment

    def log(self, item):

        """
        Логируем объект в json
        :param item: dict
        :returns Void
        """
        item['unixtime'] = self._environment.unixtime()

        self._logger.info(ujson.dumps(item))

    @classmethod
    def get_or_create_yt_process_logger(cls, name, environment):
        name_with_pid = '{}-{}'.format(name, os.getpid())
        if name_with_pid in cls.LOGGER_REGISTRY:
            return cls.LOGGER_REGISTRY[name_with_pid]

        base_logger = YtLogger(name, environment)
        process_logger = YtLogger(name_with_pid, environment)
        for h in process_logger._logger.handlers:
            process_logger._logger.removeHandler(h)
        for h in base_logger._logger.handlers:
            process_logger._logger.addHandler(h)
        process_logger._logger.propagate = False
        process_logger._logger.setLevel(logging.INFO)
        cls.LOGGER_REGISTRY[name_with_pid] = process_logger
        return process_logger
