# -*- coding: utf-8 -*-
from travel.avia.library.python.django_namedtuples import patch_django_queryset  # импортируем патч джанги
from travel.avia.library.python.ticket_daemon.caches.services import services_warm_group

from travel.avia.ticket_daemon_api.jsonrpc.lib.timer import Timer

from travel.avia.ticket_daemon_api.jsonrpc.models_utils.avia_company import company_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.geo import geo_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.geo_rasp import geo_rasp_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.order import order_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.translations import translate_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.price_list import price_list_warm_group
from travel.avia.ticket_daemon_api.jsonrpc.models_utils.search_codes import search_codes_warmup_group

patch_django_queryset()


def warm_up_cache(logger):
    timer = Timer()
    _id = str(timer.start_time.strftime('%d:%H%M%S.%f'))
    logger.info('Warm up worker [%s]', _id)

    groups = [
        company_warm_group,
        geo_warm_group,
        geo_rasp_warm_group,
        order_warm_group,
        translate_warm_group,
        price_list_warm_group,
        services_warm_group,
        search_codes_warmup_group,
    ]
    for group in groups:
        group.warm_up(logger)

    logger.info('Warm up done [%s] elapsed %s ms',
                _id, int(timer.elapsed.total_seconds() * 1000))
