# -*- coding: utf-8 -*-
from collections import namedtuple

from travel.avia.library.python.ticket_daemon.memo import memoize, CacheWithKeyTTL

from travel.avia.library.python.avia_data.models.limits import Limit

APILimit = namedtuple('APILimit', ('limit', 'update_period', 'update_time'))


@memoize(cache=CacheWithKeyTTL(15 * 60))
def jsend_api_limits():
    res = {}
    for limit in Limit.objects.all().values(
        'limit', 'update_period', 'update_time',
        'api_handler__handler', 'service__service', 'service__limited',
    ):
        if limit['service__limited']:
            handler = limit['api_handler__handler']
            service = limit['service__service']
            res.setdefault(handler, {})[service] = APILimit(
                limit['limit'], limit['update_period'], limit['update_time']
            )
    return res
