# -*- coding: utf-8 -*-


class PartnerQueryingInfo(object):
    def __init__(self, status, query_time, qid):
        # type: (basestring, float, str) -> None

        self._status = status
        self._query_time = query_time
        self._qid = qid

    @property
    def status(self):
        # type: () -> basestring

        return self._status

    @property
    def query_time(self):
        # type: () -> float

        return self._query_time

    @property
    def qid(self):
        # type: () -> str

        return self._qid

    def to_dict(self):
        return {
            'status': self.status,
            'query_time': self.query_time,
            'qid': self.qid,
        }

    def __eq__(self, other):
        if not isinstance(other, PartnerQueryingInfo):
            return False

        return (
            self.status == other.status and
            self.query_time == other.query_time and
            self.qid == other.qid
        )
