# -*- encoding: utf-8 -*-

import ujson

from marshmallow import Schema
from marshmallow.schema import MarshalResult


def camelcase():
    yield unicode.lower
    while True:
        yield unicode.capitalize


def underscore_to_camelcase(value):
    c = camelcase()
    return ''.join(c.next()(x) if x else '_' for x in unicode(value).split('_'))


def camelcase_dict(d):
    return {
        underscore_to_camelcase(key): value
        for key, value in d.items()
    }


def convert_keys(d):
    word_ = 'from_'
    if word_ in d:
        d['from'] = d[word_]
        del d[word_]

    return camelcase_dict(d)


class TypeSchema(Schema):
    class Meta:
        json_module = ujson

    def dump(self, *args, **kwargs):
        result = super(TypeSchema, self).dump(*args, **kwargs)
        data = result.data

        if not data:
            return result

        if isinstance(data, dict):
            return MarshalResult(convert_keys(data), result.errors)

        if isinstance(data, list):
            return MarshalResult([convert_keys(i) for i in data], result.errors)

        return result
