# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

"""
Запуск в проде/тестинге:
    Y_PYTHON_ENTRY_POINT="travel.avia.ticket_daemon_api.scripts.create_banned_variants_table:main" /app/app
"""
import argparse
import logging
import sys

import django

django.setup()

from travel.avia.library.python.ticket_daemon.ydb.banned_variants.cache import BannedVariantsCache
from travel.avia.library.python.ticket_daemon.ydb.django.utils import session_manager


logger = logging.getLogger(__name__)


def handle_verbose(verbose):
    if verbose:
        logger.addHandler(logging.StreamHandler(sys.stdout))
        logger.setLevel(logging.DEBUG)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true')

    args = parser.parse_args()
    handle_verbose(args.verbose)

    logger.info('Start create table')

    banned_variants_cache = BannedVariantsCache(
        session_manager=session_manager,
    )

    result = banned_variants_cache.create_tables()

    return result
