PY2TEST()

OWNER(g:avia)

PEERDIR(
    travel/avia/library/python/tester
    travel/avia/ticket_daemon_api

    contrib/python/attrs
    contrib/python/decorator
    contrib/python/freezegun
    contrib/python/pytest-httpretty
    contrib/python/mock
    contrib/python/more-itertools
    contrib/python/PyHamcrest
    contrib/python/factory-boy
    contrib/python/PyYAML
    contrib/python/requests-mock
)

IF(NOT SKIP_TESTS_RECIPE)
    INCLUDE(${ARCADIA_ROOT}/travel/avia/library/python/recipe/recipe.inc)
ENDIF()

PY_SRCS(
    conftest.py
    tests_settings.py
    fixtures/__init__.py
    fixtures/api_variants.py
    handlers/v3/utils.py
    lib/fare_families/__init__.py
    daemon_tester/__init__.py
)

TEST_SRCS(
    handlers/v3/test_api.py
    handlers/v3/test_order_params_schema.py
    handlers/v3/test_prepare_querying_verbose_info.py
    handlers/v3/test_redirect_params_schema.py
    handlers/v3/test_results_meta.py
    handlers/v3/test_serialization.py
    handlers/v3/test_views.py
    lib/fare_families/test_fare_families.py
    lib/fare_families/test_fare_families_data_validator.py
    lib/result/test_continuation.py
    lib/result/test_variants.py
    lib/result/test_wizard_variants.py
    lib/test_ab_flags.py
    lib/test_baggage.py
    lib/test_enabled_partner_provider.py
    lib/test_flights.py
    lib/test_internal_daemon_client.py
    lib/test_partner_status_fetcher.py
    lib/test_partner_timeout_provider.py
    lib/test_request_timeline.py
    lib/test_tariff_serializer.py
    lib/yt_loggers/test_api_variants.py
    models_utils/test_geo.py
    models_utils/test_order.py
    models_utils/test_search_codes.py
    response_models/test_partner_querying_info.py
    test_carry_on_bucket_size.py
    test_flight_tag.py
    test_health.py
    test_query.py
    test_rasp_complete_results.py
    test_redirect_link.py
    test_schemas_fields.py
    test_validation.py
    views/test_views.py
)

RESOURCE_FILES(
    PREFIX travel/avia/ticket_daemon_api/tests/
    lib/fare_families/fixtures/expected_results.json
)

NO_CHECK_IMPORTS()  # do not pass because of django

SIZE(MEDIUM)

END()
