#!/usr/bin/env bash

ROOT=`pwd`
LOGIN=`whoami`
export AVIA_TICKET_HTTP_API_BIND_ADDRESS="unix:/tmp/ticket-daemon-api.sock"
export AVIA_TICKET_HTTP_API_LOG_LEVEL="DEBUG"
export AVIA_TICKET_HTTP_API_LOG_PATH="$ROOT/log"
export AVIA_TICKET_HTTP_API_YT_LOG_PATH="$ROOT/log"
export AVIA_TICKET_HTTP_API_GUNICORN_LOG="-"
export AVIA_TICKET_HTTP_API_GUNICORN_WORKERS_COUNT=1
export AVIA_TICKET_HTTP_API_DJANGO_SETTINGS_MODULE="travel.avia.ticket_daemon_api.api_settings"
export AVIA_TICKET_HTTP_API_ENVIRONMENT_TYPE="development"
export AVIA_TICKET_HTTP_API_SECRET_KEY="Some"
export AVIA_TICKET_HTTP_API_MCR_HOST="localhost:11211"
export AVIA_TICKET_HTTP_API_MYSQL_DATABASE_NAME="avia"
export AVIA_TICKET_HTTP_API_MYSQL_TEST_DATABASE_NAME="avia_tests"
export AVIA_TICKET_HTTP_API_MYSQL_USER="root"
export AVIA_TICKET_HTTP_API_MYSQL_PASSWORD=""

export AVIA_TICKET_HTTP_API_TICKET_DAEMON_URL="http://ticket-daemon-internal.$LOGIN.avia.dev.yandex.net"
export AVIA_TICKET_HTTP_API_TRAVEL_HOST_FOR_RU="travel-test.yandex.ru"
export AVIA_TICKET_HTTP_API_FRONT_HOST_FOR_RU="avia-frontend.$LOGIN.avia.dev.yandex.ru"
export AVIA_TICKET_HTTP_API_FRONT_HOST_FOR_COM="avia-frontend.$LOGIN.avia.dev.yandex.com"
export AVIA_TICKET_HTTP_API_FRONT_HOST_FOR_TR="avia-frontend.$LOGIN.avia.dev.yandex.com.tr"
export AVIA_TICKET_HTTP_API_FRONT_HOST_FOR_UA="avia-frontend.$LOGIN.avia.dev.yandex.ua"
export AVIA_TICKET_HTTP_API_FRONT_HOST_FOR_KZ="avia-frontend.$LOGIN.avia.dev.yandex.kz"
export AVIA_TICKET_HTTP_API_CURRENCY_RATES_URL="http://units-converter-r1.n.yandex-team.ru/converter-rasp"
export AVIA_TICKET_HTTP_API_FEATURE_FLAG_HOST=
export AVIA_TICKET_HTTP_API_PARTNER_QUERY_TIMEOUT=120
export DJANGO_SETTINGS_MODULE="travel.avia.ticket_daemon_api.api_settings"
export AVIA_TICKET_HTTP_API_SENTRY_DSN="http://PLEASE:USE@sentry.testing.avia.yandex.net/YOUR_SENTRY"
export AVIA_TICKET_HTTP_API_ENABLE_TVM="false"

export AVIA_TICKET_HTTP_API_YDB_TOKEN="!!!Take your own OAUTH token from https://ydb.yandex-team.ru!!!"
export AVIA_TICKET_HTTP_API_YDB_ENDPOINT=ydb-ru-sas-1025.search.yandex.net:31071
export AVIA_TICKET_HTTP_API_YDB_DATABASE=/ru/home/$LOGIN/mydb
export AVIA_TICKET_HTTP_API_WIZARD_YDB_ENDPOINT=ydb-ru-sas-1025.search.yandex.net:31071
export AVIA_TICKET_HTTP_API_WIZARD_YDB_DATABASE=/ru/home/$LOGIN/mydb

export DEVELOPMENT_FLAGS=

# testing redis
export AVIA_TICKET_HTTP_API_CACHE_REDIS=true
export AVIA_TICKET_HTTP_API_REDIS_CLUSTER_ID=mdbsaji6c5vu8ropis39
export AVIA_TICKET_HTTP_API_REDIS_SENTINEL_SERVICE_NAME=ticket-daemon-api-storage-testing
export AVIA_TICKET_HTTP_API_REDIS_PASSWORD=# see https://yav.yandex-team.ru/secret/sec-01fkndx4dc83kv5qeqz3xhzyvw

export AVIA_TICKET_HTTP_API_SHARED_CACHE_REDIS=true
export AVIA_TICKET_HTTP_API_SHARED_REDIS_CLUSTER_ID=
export AVIA_TICKET_HTTP_API_SHARED_REDIS_SENTINEL_SERVICE_NAME=
export AVIA_TICKET_HTTP_API_SHARED_REDIS_PASSWORD=
