PY2_LIBRARY(ticket-daemon-api)

OWNER(g:avia)

PEERDIR(
    # Avia dependencies
    travel/avia/library/python/avia_data
    travel/avia/library/python/common
    travel/avia/library/python/environment_helpers
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/flask_helpers
    travel/avia/library/python/http_geobase
    travel/avia/library/python/redis
    travel/avia/library/python/shared_flights_client
    travel/avia/library/python/shared_objects
    travel/avia/library/python/ticket_daemon
    travel/avia/library/python/ticket_daemon/caches
    travel/avia/library/python/ticket_daemon/date
    travel/avia/library/python/ticket_daemon/decorators
    travel/avia/library/python/ticket_daemon/memo
    travel/avia/library/python/ticket_daemon/ydb
    travel/avia/library/python/ticket_daemon/ydb/banned_variants
    travel/avia/library/python/ticket_daemon/ydb/django
    travel/avia/ticket_daemon_api/jsonrpc/handlers/v3
    travel/avia/ticket_daemon_api/jsonrpc/lib/ydb
    travel/proto/avia/wizard

    # Travel dependencies
    travel/library/python/avia_mdb_replica_info
    travel/library/python/gunicorn/worker_watcher
    travel/library/python/solomon
    travel/library/python/tvm_ticket_provider
    travel/orders/proto

    # hemi
    travel/rasp/library/python/hemi

    # Yandex dependencies
    ydb/public/sdk/python
    library/python/python-django-tanker
    library/python/ylog
    library/python/gunicorn

    # Tracing dependencies
    contrib/python/Flask-OpenTracing
    contrib/python/jaeger-client
    contrib/python/opentracing-instrumentation
    contrib/python/tornado/tornado-4
    travel/library/python/tracing/flask_opentracing_helpers

    # Other dependencies
    contrib/python/Babel
    contrib/python/decorator
    travel/avia/library/python/django_namedtuples
    contrib/python/django-redis
    contrib/python/Flask
    contrib/python/flask-swagger-ui
    contrib/python/geoindex
    contrib/python/gevent
    contrib/python/greenlet
    contrib/python/gunicorn
    contrib/python/httplib2
    contrib/python/lxml
    contrib/python/marshmallow/py2
    contrib/python/MySQL-python
    contrib/python/protobuf
    contrib/python/Pygments
    contrib/python/pyOpenSSL
    contrib/python/dateutil
    contrib/python/pytils
    contrib/python/pytz
    contrib/python/raven
    contrib/python/redis
    contrib/python/requests
    contrib/python/retrying
    contrib/python/scour
    contrib/python/setuptools
    contrib/python/statsd
    contrib/python/typing
    contrib/python/ujson

    # For good console in manage.py
    contrib/python/ipython
)

PY_SRCS(
    api_settings.py
    api_wsgi.py
    app.py
    environment.py
    jsonrpc/application.py
    jsonrpc/carry_on_size_bucket.py
    jsonrpc/complete_results.py
    jsonrpc/controllers/check_sentry.py
    jsonrpc/gunicorn_conf.py
    jsonrpc/handlers/avia_api/complete_results.py
    jsonrpc/handlers/avia_api/scheme.py
    jsonrpc/handlers/avia_api/views.py
    jsonrpc/handlers/rasp/scheme.py
    jsonrpc/handlers/rasp/views.py
    jsonrpc/handlers/scheme.py
    jsonrpc/handlers/td_processing/views.py
    jsonrpc/handlers/wizard/scheme.py
    jsonrpc/handlers/wizard/views.py
    jsonrpc/health.py
    jsonrpc/jsend.py
    jsonrpc/lib/baggage.py
    jsonrpc/lib/caches.py
    jsonrpc/lib/currencies.py
    jsonrpc/lib/date.py
    jsonrpc/lib/decorators.py
    jsonrpc/lib/enabled_partner_provider.py
    jsonrpc/lib/fare_families/__init__.py
    jsonrpc/lib/fare_families/data_validator.py
    jsonrpc/lib/fare_families/fare_families.py
    jsonrpc/lib/feature_flags.py
    jsonrpc/lib/flights.py
    jsonrpc/lib/http.py
    jsonrpc/lib/internal_daemon_client.py
    jsonrpc/lib/log_setup.py
    jsonrpc/lib/mysql_switcher/base.py
    jsonrpc/lib/mysql_switcher/signals.py
    jsonrpc/lib/partner_store_time_provider.py
    jsonrpc/lib/partner_timeout_provider.py
    jsonrpc/lib/partners_utils.py
    jsonrpc/lib/redirect.py
    jsonrpc/lib/request_timer.py
    jsonrpc/lib/result/__init__.py
    jsonrpc/lib/result/collector/big_beauty.py
    jsonrpc/lib/result/collector/status.py
    jsonrpc/lib/result/collector/test_context.py
    jsonrpc/lib/result/collector/utils.py
    jsonrpc/lib/result/collector/variants.py
    jsonrpc/lib/result/collector/variants_fabric.py
    jsonrpc/lib/result/collector/variants_fetcher.py
    jsonrpc/lib/result/continuation.py
    jsonrpc/lib/result/result.py
    jsonrpc/lib/saas.py
    jsonrpc/lib/tariff_serializer.py
    jsonrpc/lib/timer.py
    jsonrpc/lib/utils.py
    jsonrpc/lib/yaclid.py
    jsonrpc/lib/yt_loggers/api_variants.py
    jsonrpc/lib/yt_loggers/yt_logger.py
    jsonrpc/limits.py
    jsonrpc/models_utils/__init__.py
    jsonrpc/models_utils/api_limits.py
    jsonrpc/models_utils/avia_company.py
    jsonrpc/models_utils/geo.py
    jsonrpc/models_utils/geo_rasp.py
    jsonrpc/models_utils/order.py
    jsonrpc/models_utils/price_list.py
    jsonrpc/models_utils/search_codes.py
    jsonrpc/models_utils/translations.py
    jsonrpc/query.py
    jsonrpc/rasp/complete_results.py
    jsonrpc/response_models/partner_querying_info.py
    jsonrpc/schemas/base.py
    jsonrpc/schemas/fields.py
    jsonrpc/schemas/reference_front.py
    jsonrpc/views.py
    jsonrpc/ydb_settings.py
    scripts/refresh_currency_converter_cache.py
    scripts/create_banned_variants_table.py
    scripts/examine_cache.py
)

RESOURCE_FILES(
    PREFIX travel/avia/ticket_daemon_api/
    data/fare_families/7_belavia.json
    data/fare_families/23_s_seven.json
    data/fare_families/26_aeroflot.json
    data/fare_families/29_utair.json
    data/fare_families/30_ural-airlines.json
    data/fare_families/50_aurora.json
    data/fare_families/69_yamal.json
    data/fare_families/80_smartavia.json
    data/fare_families/96_rusline.json
    data/fare_families/142_air-astana.json
    data/fare_families/320_air-baltics.json
    data/fare_families/617_red-wings.json
    data/fare_families/674_air-france.json
    data/fare_families/675_finnair.json
    data/fare_families/1364_nordstar.json
    data/fare_families/1373_emirates.json
    data/fare_families/1418_klm.json
    data/fare_families/2543_nordwind.json
    data/fare_families/8565_rossia.json
    data/fare_families/9144_pobeda.json
    data/fare_families/60780_azimuth.json
    data/fare_families_expressions/26_aeroflot.xml
    data/fare_families_expressions/96_rusline.xml
)

END()

RECURSE_FOR_TESTS(
    tests
    smalltests
)

RECURSE(
    bin
)
