# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.ticket_daemon_processing.local_settings')


def manage():
    from django.core.management import execute_from_command_line

    print('Loading manage.py')
    execute_from_command_line(sys.argv)


def celery():
    OPEN_FILES_LIMIT = int(os.environ.get('OPEN_FILES_LIMIT', 0))
    if OPEN_FILES_LIMIT:
        import resource
        resource.setrlimit(resource.RLIMIT_NOFILE, (OPEN_FILES_LIMIT, OPEN_FILES_LIMIT))

    import django
    from django.conf import settings

    settings.FAIL_ON_USING_DB_WITHOUT_CONTEXT = False

    django.setup()

    from travel.avia.ticket_daemon_processing.pretty_fares.messaging.tasks import celery_app

    celery_app.start()
