# -*- coding: utf-8 -*-
# flake8: noqa
from travel.avia.library.python.common import qloud
from travel.avia.ticket_daemon_processing.migration_settings import *  # noqa
from travel.avia.ticket_daemon_processing.pretty_fares.settings import *


ROOT_URLCONF = None
ALLOW_GEOBASE = False
LOG_PATH = os.getenv('AVIA_LOG_PATH')
PROJECT_PATH = os.getenv('AVIA_PROJECT_PATH')
CACHE_PATH = os.getenv('AVIA_CACHE_PATH')
FEATURE_FLAG_HOST = os.getenv('AVIA_FEATURE_FLAG_HOST')

CURRENT_DC = qloud.get_current_dc()

MDB_API_TOKEN = os.getenv('AVIA_YC_OAUTH_TOKEN')
MYSQL_CLUSTER_ID = os.getenv('AVIA_MYSQL_CLUSTER_ID')
apply_environment_settings(
    settings=globals(),
    conductor=None,
)

DISABLE_MYSQL = False

SENTRY_DSN = os.getenv('AVIA_SENTRY_DSN')

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s: %(message)s'
        },
        'message_only': {
            'format': '%(message)s'
        },
    },
    'handlers': {
        'tree_handler': {
            'level': 'INFO',
            'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
            'base_path': LOG_PATH,
            'formatter': 'verbose',
            'remove_prefix': 'travel.avia.ticket_daemon_processing',
        },
        'metrics_tree_handler_message_only': {
            'level': 'INFO',
            'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
            'base_path': os.path.join(LOG_PATH, 'metrics'),
            'formatter': 'message_only',
            'remove_prefix': 'travel.avia.ticket_daemon_processing',
        },
    },
    'loggers': {
        '': {
            'handlers': ['tree_handler'],
            'level': 'INFO',
        },
        'wizard_tasks_metrics': {
            'handlers': ['metrics_tree_handler_message_only'],
            'level': 'INFO',
            'propagate': False,
        },
    }
}
