# -*- coding: utf-8 -*-
from logging import getLogger
from decorator import decorator

from travel.avia.library.python.common.lib.timer import Timeline

log = getLogger(__name__)


def safe_run(timeline=None):
    if not isinstance(timeline, Timeline):
        timeline = None

    @decorator
    def func_wrapper(func, *args, **kwargs):

        try:
            return func(*args, **kwargs)

        except Exception as exc:
            if timeline:
                timeline.event('Exception ' + str(exc))
            log.exception(exc)

    return func_wrapper
