# -*- coding: utf-8 -*-

from typing import List, Optional

from travel.avia.ticket_daemon_processing.pretty_fares.internal_logic.point_key import PointKey, PointKeyType
from travel.avia.ticket_daemon_processing.pretty_fares.models_utils.geo import settlement_id_by_station_id, airports_ids_by_settlement_id


def get_settlement_point_key(point_key):
    # type: (PointKey) -> Optional[PointKey]

    if point_key.is_station():
        settlement_id = settlement_id_by_station_id(point_key.id)
        if settlement_id:
            return PointKey(PointKeyType.Settlement, settlement_id)

    if point_key.is_settlement():
        return point_key

    return None


def get_possible_flight_points(settlement_point_key):
    # type: (PointKey) -> List[PointKey]

    return [settlement_point_key] + get_airports_related_to_settlement(settlement_point_key)


def get_airports_related_to_settlement(settlement_point_key):
    # type: (PointKey) -> List[PointKey]

    return [
        PointKey(PointKeyType.Station, airport_id)
        for airport_id in airports_ids_by_settlement_id(settlement_point_key.id)
    ]
